package editor;

import game.CustomImageDataII;
import game.PonyPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;



public class BackgroundPanel extends JPanel {
	
	PreviewCanvas hugePreviewScreen = null;
	JList listComponent = null;
	DefaultListModel listModel = null;
	
	JTextArea totalFrameCount = null;
	
	private ListedImage clipboard = null;
	
	JDialog parent = null;
//	private JTabbedPane tabbedPaneOne;
//	private int tabbedPaneOneIndex;
//	private JTabbedPane tabbedPaneTwo;
//	private int tabbedPaneTwoIndex;
	
	private JButton previewButton;
	private JButton clearAllButton;
	private JButton browseImageButton;
	private JButton removeImageButton;
	private JButton upButton;
	private JButton downButton;
	private JButton changeFrameCountButton;
	
	private boolean showWidePreview;
	
	public BackgroundPanel (JDialog theParent, 
            String caption,
            boolean wide,
            CustomImageDataII imageArray[]) {
		
		this(theParent, caption, wide);
		
		int arrayLength = 0;
		if(imageArray != null)
			arrayLength = imageArray.length;
		
		
		uponPanelCountChange(arrayLength);
		
		for(int i = 0; i < arrayLength; i++) {
			listModel.set(i, new ListedImage(imageArray[i].getFileName(), imageArray[i].getImage()));
		}
		
		totalFrameCount.setText(Integer.toString(arrayLength));
		
	}
	
	
	public BackgroundPanel (JDialog theParent, 
			                String caption,
			                boolean wide) {
//			                JTabbedPane theTabbedPaneOne,
//					        int theTabbedPaneOneIndex,
//					        JTabbedPane theTabbedPaneTwo,
//					        int theTabbedPaneTwoIndex
		
		parent = theParent;
//		tabbedPaneOne = theTabbedPaneOne;
//		tabbedPaneOneIndex = theTabbedPaneOneIndex;
//		tabbedPaneTwo = theTabbedPaneTwo;
//		tabbedPaneTwoIndex = theTabbedPaneTwoIndex;
		showWidePreview = wide;
		
		BorderLayout borderLayout = new BorderLayout();
		
		this.setLayout(borderLayout);
		
		JPanel middlePanel = new JPanel();
		JPanel middleLeftPanel = new JPanel();
		JPanel middleLeftInnerPanel = new JPanel();
		JPanel middleLeftLowerPanel = new JPanel();
		JPanel middleRightPanel = new JPanel();
		JPanel middleRightInnerPanel = new JPanel();
		JPanel middleRightLowerPanel = new JPanel();
		
		GridLayout gridLayout = new GridLayout(1, 2);
		BorderLayout borderLayoutLeft = new BorderLayout();
		GridBagLayout gridLayoutLeftLower = new GridBagLayout();
		BorderLayout borderLayoutRight = new BorderLayout();
		GridBagLayout gridLayoutRightLower = new GridBagLayout();
		FlowLayout flowLayoutLeft = new FlowLayout();
		FlowLayout flowLayoutRight = new FlowLayout();
		FlowLayout flowLayoutUpper = new FlowLayout();
		
		middlePanel.setLayout(gridLayout);
		
		hugePreviewScreen = new PreviewCanvas(false, null, true);
//		hugePreviewScreen.setAlignmentX(JLabel.CENTER_ALIGNMENT);
//		hugePreviewScreen.setAlignmentY(JLabel.CENTER_ALIGNMENT);
//		
//		
//		hugePreviewScreen.setPreferredSize(new Dimension(200, 200));
//		hugePreviewScreen.setMinimumSize(new Dimension(200, 200));
//		hugePreviewScreen.setMaximumSize(new Dimension(200, 200));
		
		BorderFactory border = null;
		Border hugePreviewScreenBorder = BorderFactory.createLineBorder(new Color(0,0,0));
		
		hugePreviewScreen.setBorder(hugePreviewScreenBorder);
		
		
		listModel = new DefaultListModel();
		listComponent = new JList(listModel);
		listComponent.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		listComponent.addListSelectionListener(new ListSelectionListener() {
			
			public void valueChanged(ListSelectionEvent arg0) {
				// TODO Auto-generated method stub
				
				listSelectionChanged();
			}
			
		});
		listComponent.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if(!e.isControlDown())
					return;
				if(e.getKeyCode() == KeyEvent.VK_C) {
					copyImage();
				} else if(e.getKeyCode() == KeyEvent.VK_V) {
					pasteImage();
				}
			}
		});
		
		
		JScrollPane listPane = new JScrollPane();
		listPane.setPreferredSize(new Dimension(200,200));
		listPane.setMinimumSize(new Dimension(200, 200));
		listPane.setMaximumSize(new Dimension(200, 200));
		
		listPane.getViewport().setView(listComponent);
		
		
		LineBorder innerLineBorderLeft = (LineBorder) BorderFactory.createLineBorder(new Color(140, 140, 140));
		TitledBorder titleBorderLeft = new TitledBorder(innerLineBorderLeft, "Frame Preview", TitledBorder.LEFT, TitledBorder.TOP);
		
		middleLeftInnerPanel.setBorder(titleBorderLeft);
		middleLeftInnerPanel.setLayout(flowLayoutLeft);
		middleLeftInnerPanel.add(hugePreviewScreen);
		
		GridBagLayout gbl1 = new GridBagLayout();
		GridBagConstraints gbc1 = new GridBagConstraints();
		
		gbc1.fill = GridBagConstraints.BOTH;
		
		gbc1.gridwidth = GridBagConstraints.REMAINDER;
		gbc1.weightx = 0.0;
		gbc1.weighty = 0.0;
		
		
		
		//middleLeftPanel.setLayout(borderLayoutLeft);
		//middleLeftPanel.add(middleLeftInnerPanel, BorderLayout.CENTER);
		
		middleLeftPanel.setLayout(gbl1);
		
		gbl1.setConstraints(middleLeftInnerPanel, gbc1);
		
		middleLeftPanel.add(middleLeftInnerPanel);
		
		
		
		middleLeftPanel.setPreferredSize(new Dimension(200, 200));
		middleLeftPanel.setMinimumSize(new Dimension(200, 200));
		middleLeftPanel.setMaximumSize(new Dimension(200, 200));
		
		middleLeftLowerPanel.setLayout(gridLayoutLeftLower);
		previewButton = new JButton("Preview Animation");
		
		
		ActionListener previewListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				popUpPreviewWindow();
			}
		};
		previewButton.addActionListener(previewListener);
		
		JPanel previewPanel = new JPanel();
		
		previewPanel.setLayout(new FlowLayout());
		previewPanel.add(previewButton);
		
		GridBagConstraints gridLayoutLeftLowerConstraints = new GridBagConstraints();
		
		gridLayoutLeftLowerConstraints.weightx = 1.0;
		gridLayoutLeftLowerConstraints.weighty = 1.0;
		gridLayoutLeftLowerConstraints.gridwidth = GridBagConstraints.REMAINDER;
		gridLayoutLeftLowerConstraints.fill = GridBagConstraints.BOTH;
		
		
		
		
		gbc1.weighty = 1.0;
		//gbc1.gridheight = GridBagConstraints.REMAINDER;
		
		gridLayoutLeftLower.setConstraints(previewPanel,gridLayoutLeftLowerConstraints);
		
		middleLeftLowerPanel.add(previewPanel);
		
		JPanel clearAndCaptionPanel = new JPanel();
		GridLayout clearAndCaptionLayout = null;
		
		if(caption == null) {
			clearAndCaptionLayout = new GridLayout(1, 1);
			clearAndCaptionPanel.setLayout(clearAndCaptionLayout);
		} else {
			clearAndCaptionLayout = new GridLayout(2, 1);
			clearAndCaptionPanel.setLayout(clearAndCaptionLayout);
		}
		
		
		clearAllButton = new JButton("Clear All Images");
		JPanel clearAllPanel = new JPanel(new FlowLayout());
		
		
		ActionListener clearAllListener = new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				removeAllImagesFromList();
				hugePreviewScreen.setListedImage(null);
				hugePreviewScreen.refresh();
				
			}
			
		};
		clearAllButton.addActionListener(clearAllListener);
		
		clearAllPanel.add(clearAllButton);
		
		clearAndCaptionPanel.add(clearAllPanel);
		
		if(caption != null) {
			JLabel captionLabel = new JLabel(caption);
			captionLabel.setForeground(Color.RED);
			clearAndCaptionPanel.add(captionLabel);
		}
		
		gridLayoutLeftLower.setConstraints(clearAndCaptionPanel, gridLayoutLeftLowerConstraints);
		
		middleLeftLowerPanel.add(clearAndCaptionPanel);

		gbl1.setConstraints(middleLeftLowerPanel, gbc1);
		
//		middleLeftPanel.add(middleLeftLowerPanel, BorderLayout.SOUTH);
		middleLeftPanel.add(middleLeftLowerPanel);
		
		middlePanel.add(middleLeftPanel);
		
		middleRightPanel = new JPanel();
//		middleRightPanel.setLayout(borderLayoutRight);
		
		GridBagLayout gbl2 = new GridBagLayout();
		GridBagConstraints gbc2 = new GridBagConstraints();
		
		
		
		middleRightPanel.setLayout(gbl2);
		
		middleRightInnerPanel.setLayout(flowLayoutRight);
		middleRightInnerPanel.add(listPane);
		
		LineBorder innerLineBorderRight = (LineBorder) BorderFactory.createLineBorder(new Color(140, 140, 140));
		TitledBorder titleBorderRight = new TitledBorder(innerLineBorderLeft, "List of Frames", TitledBorder.LEFT, TitledBorder.TOP);
		
		middleRightInnerPanel.setBorder(titleBorderRight);
		
//		middleRightPanel.add(middleRightInnerPanel, BorderLayout.CENTER);
		
		gbc2.fill = GridBagConstraints.BOTH;
		gbc2.gridwidth = GridBagConstraints.REMAINDER;
		gbc2.weightx = 0.0;
		gbc2.weighty = 0.0;
		
		gbl2.setConstraints(middleRightInnerPanel, gbc2);
		
		middleRightPanel.add(middleRightInnerPanel);
		GridBagConstraints gbc3 = new GridBagConstraints();
		
		middleRightLowerPanel.setLayout(gridLayoutRightLower);
				
		browseImageButton = new JButton("Browse...");
		browseImageButton.setEnabled(false);
		removeImageButton = new JButton("Clear Image");
		removeImageButton.setEnabled(false);
		
		
		
		JPanel selectMultipleFilesPanel = new JPanel(new FlowLayout());
		JButton selectMultipleFilesButton = new JButton("Multiple Files...");
		selectMultipleFilesButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				JFileChooser jfc = new JFileChooser();
				jfc.setMultiSelectionEnabled(true);
				
				int result = jfc.showOpenDialog(parent);
				
				if(result == JFileChooser.APPROVE_OPTION) {
					
					result = JOptionPane.showConfirmDialog(parent, "This will clear out everything, and replace it with the files that were loaded.  Continue?","Confirm load multiple files", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
					if(result == JOptionPane.NO_OPTION)
						return;
					
					
					File fileArray[] = jfc.getSelectedFiles();
					
					
					
					
					ArrayList<ListedImage> newImages = new ArrayList<ListedImage>();
					ListedImage newImage = null;
					BufferedImage bi = null;
					for(File f : fileArray) {
//						System.out.println("A file: " + f.getAbsolutePath());
						try {
							bi = ImageIO.read(f);
						} catch(Exception e) {
							JOptionPane.showMessageDialog(parent, "Error while trying to load image file: " + f.getAbsolutePath(),"Error loading image",JOptionPane.WARNING_MESSAGE);
							return;
						}
//						newImage = new ListedCustomImage(bi, bi.getWidth(), bi.getHeight(), null, parent, f.getAbsolutePath());
						newImage = new ListedImage(f.getAbsolutePath(), bi);
						newImages.add(newImage);
					}
					
					
					totalFrameCount.setText(Integer.toString(fileArray.length));
					uponPanelCountChange();
					
					for(int i = 0; i < newImages.size(); i++) {
						listModel.setElementAt(newImages.get(i), i);
					}
					
					
					
				}
				
			}
		});
		selectMultipleFilesPanel.add(selectMultipleFilesButton);
		
		
		
		JPanel selectImagePanel = new JPanel();
		selectImagePanel.setLayout(new FlowLayout());
		
		ActionListener selectImageListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectImageIntoList();
			}
		};
		
		browseImageButton.addActionListener(selectImageListener);
		
		selectImagePanel.add(browseImageButton);
		JPanel removeImagePanel = new JPanel();
		removeImagePanel.setLayout(new FlowLayout());
		
		ActionListener removeImageListener = new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				removeImageFromList();
				hugePreviewScreen.setListedImage(null);
				hugePreviewScreen.refresh();
			}
			
		};
		removeImageButton.addActionListener(removeImageListener);
		
		removeImagePanel.add(removeImageButton);
		
		gbc3.fill = GridBagConstraints.BOTH;
		gbc3.gridwidth = GridBagConstraints.RELATIVE;
		gbc3.weightx = 1.0;
		gbc3.weighty = 1.0;
		
		gridLayoutRightLower.setConstraints(selectImagePanel, gbc3);
		middleRightLowerPanel.add(selectImagePanel);
		gbc3.gridwidth = GridBagConstraints.REMAINDER;
		gridLayoutRightLower.setConstraints(removeImagePanel, gbc3);
		middleRightLowerPanel.add(removeImagePanel);
		
		
		JPanel upAndDownPanel = new JPanel();
		GridLayout upAndDownLayout = new GridLayout(4,1);
		upAndDownPanel.setLayout(upAndDownLayout);
		
		upButton = new JButton("Move Image Up");
		upButton.setEnabled(false);
		JPanel upButtonPanel = new JPanel();
		
		ActionListener upButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				moveImageUp();
			}
		};
		
		upButton.addActionListener(upButtonListener);
		
		
		
		FlowLayout upButtonLayout = new FlowLayout();
		upButtonPanel.setLayout(upButtonLayout);
		upButtonPanel.add(upButton);
		
		downButton = new JButton("Move Image Down");
		downButton.setEnabled(false);
		JPanel downButtonPanel = new JPanel();
		
		ActionListener downButtonListener = new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				moveImageDown();
			}
		};
		downButton.addActionListener(downButtonListener);
		
		
		FlowLayout downButtonLayout = new FlowLayout();
		downButtonPanel.setLayout(downButtonLayout);
		downButtonPanel.add(downButton);
		
		upAndDownPanel.add(upButtonPanel);
		upAndDownPanel.add(downButtonPanel);
		upAndDownPanel.add(new JPanel());
		upAndDownPanel.add(selectMultipleFilesPanel);
		
		gbc3.weightx = 2.0;
		
		gridLayoutRightLower.setConstraints(upAndDownPanel, gbc3);
		
		middleRightLowerPanel.add(upAndDownPanel);
		
		
//		middleRightPanel.add(middleRightLowerPanel, BorderLayout.SOUTH);
		
		gbc2.weighty = 1.0;
		gbl2.setConstraints(middleRightLowerPanel, gbc2);
	
		
		middleRightPanel.add(middleRightLowerPanel);
		
		middlePanel.add(middleRightPanel);
		
		this.add(middlePanel, BorderLayout.CENTER);
		
		JLabel frameCountLabel = new JLabel("Number of Frames:");
		totalFrameCount = new JTextArea();
		totalFrameCount.setBorder(BorderFactory.createLoweredBevelBorder());
		totalFrameCount.setPreferredSize(new Dimension(50, 21));
		totalFrameCount.setMinimumSize(new Dimension(50, 21));
		totalFrameCount.setMaximumSize(new Dimension(50, 21));
		totalFrameCount.setText("0");
		
		//need to set up the JTextArea to affect the JList.
		
		
		JPanel upperPanel = new JPanel();
		
		upperPanel.setLayout(flowLayoutUpper);
		upperPanel.add(frameCountLabel);
		upperPanel.add(totalFrameCount);
		
		changeFrameCountButton = new JButton("Change Frame Count");

		ActionListener changeFrameCountListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				uponPanelCountChange();
			}
		};
		
		changeFrameCountButton.addActionListener(changeFrameCountListener);
		
		upperPanel.add(changeFrameCountButton);
		
		this.add(upperPanel, BorderLayout.NORTH);
		
	}
	
	
	public boolean uponPanelCountChangeOld() {
		
//		System.out.println("now in uponPanelCountChange");
		
		if(totalFrameCount == null) {
//			System.out.println("totalFrameCount was null!");
			return true;
		}
		
		String newFrameCountStr = totalFrameCount.getText();
		
		int newFrameCount;
		
		try {
			newFrameCount = Integer.parseInt(newFrameCountStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Please enter a number.");
			totalFrameCount.setText(Integer.toString(listModel.getSize()));
			totalFrameCount.requestFocus();
			return false;
		}
		
		int oldFrameCount = listModel.getSize();
		
		if(oldFrameCount == newFrameCount) {
			
//			System.out.println("oldFrameCount == newFrameCount");
			return true;
		} else if (oldFrameCount > newFrameCount) {
			int confirmation = JOptionPane.showConfirmDialog(null, "This will delete some frames.  Do you want this?", "Confirm Delete", JOptionPane.YES_NO_OPTION);
			if(confirmation == JOptionPane.YES_OPTION) {
				
				//TODO:  create the EditEvent
				
				for(int i = newFrameCount; i < oldFrameCount; i++) {
					listModel.remove(newFrameCount);
				}
//				System.out.println("removed some frames");
			} else {
				
				totalFrameCount.setText(Integer.toString(listModel.getSize()));
				
//				System.out.println("did a cancel op as per user decision");
				
				return false;
			}
		} else {
			for(int i = oldFrameCount; i < newFrameCount; i++) {
				
				ListedImage li = new ListedImage("c:\\a_folder\\b_folder/c_folder/blank", null);
				
				listModel.add(oldFrameCount, li);
			}
			
//			System.out.println("added some records to the JList");
			
		}
		
//		System.out.println("at the end, returning true.");
		return true;
		
	}
	
	public void uponPanelCountChange() {
		
		if(totalFrameCount == null) {
//			System.out.println("totalFrameCount was null!");
			return;
		}
		
		String newFrameCountStr = totalFrameCount.getText();
		
		int newFrameCount;
		
		try {
			newFrameCount = Integer.parseInt(newFrameCountStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Please enter a number.");
			totalFrameCount.setText(Integer.toString(listModel.getSize()));
			totalFrameCount.requestFocus();
			return;
		}
		
//		System.out.println("newFrameCount is: " + newFrameCount);
		
		int oldFrameCount = listModel.getSize();
		
		if(oldFrameCount == newFrameCount) {
			
//			System.out.println("oldFrameCount == newFrameCount");
			return;
		} else if (oldFrameCount > newFrameCount) {
			int confirmation = JOptionPane.showConfirmDialog(null, "This will delete some frames.  Do you want this?", "Confirm Delete", JOptionPane.YES_NO_OPTION);
			if(confirmation == JOptionPane.YES_OPTION) {
				
				//TODO:  create the EditEvent
				
				for(int i = newFrameCount; i < oldFrameCount; i++) {
					listModel.remove(newFrameCount);
				}
//				System.out.println("removed some frames");
			} else {
				
				totalFrameCount.setText(Integer.toString(listModel.getSize()));
				
//				System.out.println("did a cancel op as per user decision");
				
				return;
			}
		} else {
			for(int i = oldFrameCount; i < newFrameCount; i++) {
				
				ListedCustomImage li = new ListedCustomImage(null, 0, 0, null, null, "c:\\a_folder\\b_folder/c_folder/blank");
				
				listModel.add(oldFrameCount, li);
			}
			
//			System.out.println("added some records to the JList");
			
		}
		
//		System.out.println("at the end, returning true.");
		
		
		
	}
	
	
	

	public void uponPanelCountChange(int newFrameCount) {
		
		
//		System.out.println("newFrameCount is: " + newFrameCount);
		
		int oldFrameCount = listModel.getSize();
		
		if(oldFrameCount == newFrameCount) {
			
//			System.out.println("oldFrameCount == newFrameCount");
			return;
		} else if (oldFrameCount > newFrameCount) {
			int confirmation = JOptionPane.showConfirmDialog(null, "This will delete some frames.  Do you want this?", "Confirm Delete", JOptionPane.YES_NO_OPTION);
			if(confirmation == JOptionPane.YES_OPTION) {
				
				//TODO:  create the EditEvent
				
				for(int i = newFrameCount; i < oldFrameCount; i++) {
					listModel.remove(newFrameCount);
				}
//				System.out.println("removed some frames");
			} else {
				
				totalFrameCount.setText(Integer.toString(listModel.getSize()));
				
//				System.out.println("did a cancel op as per user decision");
				
				return;
			}
		} else {
			for(int i = oldFrameCount; i < newFrameCount; i++) {
				
				ListedCustomImage li = new ListedCustomImage(null, 0, 0, null, null, "c:\\a_folder\\b_folder/c_folder/blank");
				
				listModel.add(oldFrameCount, li);
			}
			
//			System.out.println("added some records to the JList");
			
		}
		
//		System.out.println("at the end, returning true.");
		
		
		
	}
	
	
	public void selectImageIntoList() {
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1) {
			JOptionPane.showMessageDialog(null, "You must select an image from the list in order to set the image.", "Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		ListedImage newImage = ListedImage.letUserSelectImage("Select Background Image", parent, this);
		
		if(newImage == null)
			return;
		
		//TODO create an edit event for this
		
//		mainPanel.modifySingleTabImageListOneImage(this.listComponent,
//												   this.listModel,
//												   selectedIndex,
//												   newImage,
//												   this.tabbedPaneOne,
//												   this.tabbedPaneOneIndex,
//												   this.tabbedPaneTwo,
//												   this.tabbedPaneTwoIndex);
		
		listModel.setElementAt(newImage, selectedIndex);
		listSelectionChanged();
	}
	
	
	public void listSelectionChanged() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1) {
			
//			hugePreviewScreen.setIcon(null);
//			hugePreviewScreen.setText("No image selected");
			
			hugePreviewScreen.setListedImage(null);
			hugePreviewScreen.refresh();
			
			browseImageButton.setEnabled(false);
			removeImageButton.setEnabled(false);
			upButton.setEnabled(false);
			downButton.setEnabled(false);
			
			return;
			
		}
		
		browseImageButton.setEnabled(true);
		removeImageButton.setEnabled(true);
		upButton.setEnabled(true);
		downButton.setEnabled(true);
		
		
		Object o = listModel.getElementAt(selectedIndex);
		
		if(o == null || !(o instanceof ListedImage)) {
//			hugePreviewScreen.setIcon(null);
//			hugePreviewScreen.setText("No image selected");
			
			hugePreviewScreen.setListedImage(null);
			hugePreviewScreen.refresh();
			
			return;
		}
		
		ListedImage newImage = (ListedImage) o;
		
		if(newImage.getImage() == null) {
//			hugePreviewScreen.setIcon(null);
//			hugePreviewScreen.setText("No image selected");
			
			hugePreviewScreen.setListedImage(null);
			hugePreviewScreen.refresh();
			
//			System.out.println("no image in this one!  It should've been cleared off by now...");
			
			return;
		}
		
		//Graphics g = hugePreviewScreen.getGraphics();
		
//		Icon icon = null;
//		
//		icon = new ImageIcon(newImage.getImage());
		
//		hugePreviewScreen.setIcon(icon);
//		hugePreviewScreen.setText(null);
		
		if(newImage.getImage() instanceof BufferedImage) {
			hugePreviewScreen.setListedImage((BufferedImage) newImage.getImage());
		} else {
			
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
			BufferedImage bi = gc.createCompatibleImage(newImage.getImage().getWidth(this), newImage.getImage().getHeight(this));
			Graphics g = bi.getGraphics();
			g.drawImage(newImage.getImage(), 0, 0, null);
			g.dispose();
			hugePreviewScreen.setListedImage(bi);
		}
		
//		hugePreviewScreen.setListedImage(newImage.getImage());
		hugePreviewScreen.refresh();
		
	}
	
	public void removeImageFromList() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1) {
			JOptionPane.showMessageDialog(null, "You must select an image from the list in order to clear the image.", "Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		ListedImage blankImage = new ListedImage("blank", null);
		
//		mainPanel.modifySingleTabImageListOneImage(this.listComponent,
//				   this.listModel,
//				   selectedIndex,
//				   blankImage,
//				   this.tabbedPaneOne,
//				   this.tabbedPaneOneIndex,
//				   this.tabbedPaneTwo,
//				   this.tabbedPaneTwoIndex);

		listModel.setElementAt(blankImage, selectedIndex);
		listSelectionChanged();
		
	}
	
	public void removeAllImagesFromList() {
		
		int size = listModel.getSize();
		
		for(int i = 0; i < size; i++) {
			listModel.setElementAt(new ListedImage("blank", null), i);
		}
		
//		mainPanel.modifySingleTabImageListClearAll(listComponent,
//				                                   listModel,
//				                                   this.tabbedPaneOne,
//				                				   this.tabbedPaneOneIndex,
//				                				   this.tabbedPaneTwo,
//				                				   this.tabbedPaneTwoIndex);
		
		
	}
	
	public void moveImageUp() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex < 1)
			return;
		
		ListedImage destinationImage = (ListedImage) listModel.getElementAt(selectedIndex - 1);
		ListedImage sourceImage = (ListedImage) listModel.getElementAt(selectedIndex);
		
//		mainPanel.modifySingleTabImageListMoveImage(listComponent, listModel, selectedIndex, selectedIndex - 1, 
//				sourceImage, destinationImage, this.tabbedPaneOne, this.tabbedPaneOneIndex, this.tabbedPaneTwo,
//				   this.tabbedPaneTwoIndex);
		
		
		
//		listModel.setElementAt(listModel.getElementAt(selectedIndex), selectedIndex - 1);
//		listModel.setElementAt(temp, selectedIndex);
		
		listModel.setElementAt(sourceImage, selectedIndex - 1);
		listModel.setElementAt(destinationImage, selectedIndex);
		
		
		listComponent.setSelectedIndex(selectedIndex - 1);
		
	}
	
	public void moveImageDown() {
		
		int selectedIndex = listComponent.getSelectedIndex();
		
		if(selectedIndex == -1 || selectedIndex >= (listModel.getSize() - 1)) {
			return;
		}
		
		
		ListedImage destinationImage = (ListedImage) listModel.getElementAt(selectedIndex + 1);
		ListedImage sourceImage = (ListedImage) listModel.getElementAt(selectedIndex);
		
//		mainPanel.modifySingleTabImageListMoveImage(listComponent, listModel, selectedIndex, selectedIndex + 1, 
//				sourceImage, destinationImage, this.tabbedPaneOne, this.tabbedPaneOneIndex, this.tabbedPaneTwo,
//				   this.tabbedPaneTwoIndex);
		
		
//		ListedImage temp = (ListedImage) listModel.getElementAt(selectedIndex + 1);
//		
//		listModel.setElementAt(listModel.getElementAt(selectedIndex), selectedIndex + 1);
//		listModel.setElementAt(temp, selectedIndex);
//		
		
		listModel.setElementAt(sourceImage, selectedIndex + 1);
		listModel.setElementAt(destinationImage, selectedIndex);
		
		listComponent.setSelectedIndex(selectedIndex + 1);
		
	}
	
	public void popUpPreviewWindow() {
		
		if(listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "There are no frames at all in the list!", "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		ListedImage temp = null;
		
		for(int i = 0; i < listModel.getSize(); i++) {
			
			temp = (ListedImage) listModel.get(i);
			
			if(temp == null || temp.getImage() == null) {
				JOptionPane.showMessageDialog(null, "Please set all the images before starting a preview.", "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
				return;
			}
			
		}
		
		if(showWidePreview) {
			BackgroundPreviewPopupPanel.showWidePopUp(listModel);
		} else {
			BackgroundPreviewPopupPanel.showPopUp(listModel);
		}
		
	}
	
	public BackgroundFileData getFileData() {
		
		int listSize = listModel.getSize();
		
		BackgroundFileData returnValue = new BackgroundFileData();
		
		ListedImage temp = null;
		for(int i = 0; i < listSize; i++) {
			temp = (ListedImage) listModel.getElementAt(i);
			returnValue.addFileName(temp.getFileName());
		}
		
		return returnValue;
		
	}
	
	public void setBackgroundData(BackgroundFileData fileData) {
		
		listModel.clear();
		
		ArrayList<String> filenameList = fileData.getFilenameList();
		
		ListedImage tempListedImage = null;
		Image tempImage = null;
		File tempFile = null;
		
		
		for(String fileName : filenameList) {

			tempImage = null;
			
			tempFile = new File(fileName);
			if(!tempFile.exists()) {
				ClassLoader cl = BackgroundPanel.class.getClassLoader();
				URL imageURL = cl.getResource("images\\up_threshold.JPG");
				tempImage = Toolkit.getDefaultToolkit().createImage(imageURL);
			}
			
			try {
				tempImage = ImageIO.read(tempFile);
				if(tempImage == null) {
					ClassLoader cl = BackgroundPanel.class.getClassLoader();
					URL imageURL = cl.getResource("images\\up_threshold.JPG");
					tempImage = Toolkit.getDefaultToolkit().createImage(imageURL);
				}
			} catch (IOException e) {
				ClassLoader cl = BackgroundPanel.class.getClassLoader();
				URL imageURL = cl.getResource("images\\up_threshold.JPG");
				tempImage = Toolkit.getDefaultToolkit().createImage(imageURL);
			}
			
			tempListedImage = new ListedImage(fileName, tempImage);
			
			listModel.addElement(tempListedImage);
			
		}
		
		
	}


	public JList getListComponent() {
		return listComponent;
	}


	public DefaultListModel getListModel() {
		return listModel;
	}


//	public JTabbedPane getTabbedPaneOne() {
//		return tabbedPaneOne;
//	}
//
//
//	public int getTabbedPaneOneIndex() {
//		return tabbedPaneOneIndex;
//	}
//
//
//	public JTabbedPane getTabbedPaneTwo() {
//		return tabbedPaneTwo;
//	}
//
//
//	public int getTabbedPaneTwoIndex() {
//		return tabbedPaneTwoIndex;
//	}


	public JTextArea getTotalFrameCount() {
		return totalFrameCount;
	}
	
	public void grayOutFrameCount() {
		this.changeFrameCountButton.setEnabled(false);
	}
	
	public void enableFrameCount() {
		this.changeFrameCountButton.setEnabled(true);
	}
	
	
	public CustomImageDataII[] getImageArray() {
		
		int size = listModel.getSize();
		CustomImageDataII returnValue[] = new CustomImageDataII[size];
		
		for(int i = 0; i < size; i++) {
			returnValue[i] = (CustomImageDataII) listModel.get(i);
		}
		
		return returnValue;
	}
	
	public ListedImage[] getListedImageArray() {
		
		int size = listModel.getSize();
		ListedImage returnValue[] = new ListedImage[size];
		
		for(int i = 0; i < size; i++) {
			returnValue[i] = (ListedImage) listModel.get(i);
		}
		
		return returnValue;
	}
	
	public String returnAnimationAsFileString() {
		
		StringWriter writer = new StringWriter();
		BufferedWriter out = new BufferedWriter(writer);
		
		ListedImage images[] = getListedImageArray();
		
		try {
			
			out.write(Integer.toString(images.length));
			out.newLine();
			
			for(int i = 0; i < images.length; i++) {
				
				out.write(images[i].getFileName());
				out.newLine();
				
			}
			
			out.close();
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			JOptionPane.showMessageDialog(null,  "Error occurred: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		
		return writer.getBuffer().toString();
		
	}
	
	public String convertColorToString(Color color) {
		
		if(color == null)
			return "null";
		return color.getRed() + ":" + color.getGreen() + ":" + color.getBlue();
		
	}
	
	public boolean validateIsReadyForPreview(String nameOfPanel) {
		
		if(listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "There are no images in the panel:  " + nameOfPanel, "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		ListedImage temp = null;
		
		for(int i = 0; i < listModel.getSize(); i++) {
			
			temp = (ListedImage) listModel.get(i);
			
			if(temp == null || temp.getImage() == null) {
				JOptionPane.showMessageDialog(null, "Please set all the images before starting a preview; image number " + (i + 1) + " in " + nameOfPanel + " was not set.", "Preview Unavailable", JOptionPane.ERROR_MESSAGE);
				return false;
			}
			
		}
		
		return true;
		
	}
	
	public Color convertStringToColor(String str) {
		
		if(str == null || str.trim().equalsIgnoreCase("null"))
			return null;
		
		int redInt;
		int greenInt;
		int blueInt;
		
		String componentArray[] = str.split(":");
		
		redInt = Integer.parseInt(componentArray[0]);
		greenInt = Integer.parseInt(componentArray[1]);
		blueInt = Integer.parseInt(componentArray[2]);
		
		return new Color(redInt, greenInt, blueInt);
		
	}
	
	
	public void loadFromBufferedReader(BufferedReader in) throws IOException {
		
		String inputter = null;
		
		inputter = in.readLine();
		
//		System.out.println("<><>DELME now in loadFromBufferedReader; inputter is: " + inputter);
		
		int countOfFrames = Integer.parseInt(inputter);
		
		ListedImage tempLCI = null;
		Image tempImage = null;
		String tempFileName = null;
		
		for(int i = 0; i < countOfFrames; i++) {
			
			inputter = in.readLine();
			tempFileName = inputter;
			if(inputter != null && inputter.length() > 0 && !inputter.trim().equalsIgnoreCase("blank"))
				tempImage = ImageIO.read(new File(inputter));
			else tempImage = null;
			
			tempLCI = new ListedImage(tempFileName,tempImage);
			
			listModel.addElement(tempLCI);
			
		}
		
		listSelectionChanged();
		
		totalFrameCount.setText(Integer.toString(countOfFrames));
		
	}
	
	

	public void cleanSlate() {
		
		listModel.clear();
		listSelectionChanged();
		
		
	}
	
	
	
	public void saveToBufferedWriter(BufferedWriter out) throws IOException {
		
		int countOfFrames = listModel.getSize();
		
		out.write(Integer.toString(countOfFrames));
		out.newLine();
		
		String tempFileName;
		
		ListedImage tempLCI;
		
		for(int i = 0; i < countOfFrames; i++) {
			
			tempLCI = (ListedImage) listModel.getElementAt(i);
			
			tempFileName = tempLCI.getFileName();
			
			
			out.write(tempFileName);
			out.newLine();
			
			
		}
		
	}
	
	
	public boolean validateIsReadyToBeSaved(String nameOfPanel) {
		
		if(listModel.getSize() == 0) {
			JOptionPane.showMessageDialog(null, "There are no images in the panel:  " + nameOfPanel, "Unable to save", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		
		ListedImage temp = null;
		
		for(int i = 0; i < listModel.getSize(); i++) {
			
			temp = (ListedImage) listModel.get(i);
			
			if(temp == null || temp.getImage() == null) {
				JOptionPane.showMessageDialog(null, "Please set all the images on the panel " + nameOfPanel + " before saving; image number " + (i + 1) + " in " + nameOfPanel + " was not set.", "Unable to save", JOptionPane.ERROR_MESSAGE);
				return false;
			}
			
		}
		
		return true;
		
	}
	
	
	
	public CustomImageDataII[] getFinalResult() {
		
		CustomImageDataII returnValue[] = new CustomImageDataII[listModel.size()];
		
		ListedImage li = null;
		
		for(int i = 0; i < returnValue.length; i++) {
			
			li = (ListedImage) listModel.get(i);
			
			returnValue[i] = new CustomImageDataII(new File(li.getFileName()), null, this, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
		}
		
		
		
		return returnValue;
		
	}
	
	private void copyImage() {
		int index = this.listComponent.getSelectedIndex();
		if(index < 0)
			return;
		
		ListedImage selected = (ListedImage) this.listModel.get(index);
		if(selected == null || selected.getFileName().equals("blank"))
			return;
		
		this.clipboard = new ListedImage(selected.getFileName(), selected.getImage());
	}
	
	private void pasteImage() {
		int index = this.listComponent.getSelectedIndex();
		if(index < 0)
			return;
		
		if(this.clipboard == null)
			return;
		
		ListedImage newImage = new ListedImage(this.clipboard.getFileName(), this.clipboard.getImage());
		
		listModel.set(index, newImage);
	}
	
	
}